
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Sun Jul 22 10:17:10 2007
   *  Last modified   :  %modify_time%
   */
  /** @file 
   *  \brief This file includes the KMNG create, import and export keys 
   *          ATP tests						 
   *
   *  \version KMNG_SEP_ATP_ImportExportKeys.c#1:csrc:1
   *  \author Annag
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ****************/
#include <stdio.h>
#include "DX_VOS_BaseTypes.h"
#include "DX_VOS_Mem.h"
#include "CRYS.h"
#include "CRYS_KMNG.h"
#include "CRYS_AES.h"
#include "CRYS_DES.h"
#include "CRYS_error.h"
#include "CRYS_HASH.h"
#include "CRYS_HMAC.h"
#include "CRYS_RSA_Types.h"
#include "KMNG_Defs.h"
#include "KMNG_SEP_ATP_Defines.h"
#include "SEP_ATP_UTIL_funcs.h"
#include "KMNG_SEP_ATP_ImportExportKeys.h"

#include "KMNG_Defs.h"
#include "LLF_KMNG.h"
#include "KMNG_SEP_ATP_ImportExportKeys.h"
#include "KMNG_SEP_ATP_TestDataDefines.h"



/************************ Defines *******************************/
/************************ Enums *********************************/
/************************ Typedefs ******************************/
/************************ Global Data ***************************/

/* pointer to the struct with symmetric key test data vector */
TST_Ext_KeysSym_TestDataStruct *SEP_KeysOpSym_TestData;

/* pointer to the struct with RSA key test data vector */
TST_Ext_KeysRSA_TestDataStruct *SEP_KeysOpRSA_TestData;


/************* Private function prototype ***********************/
/************************ Public Functions ******************************/

/***********************************************************************
* Function Name:                                                           
*  SEP_KMNG_ATP_Ext_ImportExportSymKeys         
* 
* Inputs:
*
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for create, import, export of the symmetric keys.
* Algorithm:       
* 1. Create a master key
* 2. Import symmetric key
* 3. Export symmetric key                                            
* 4. Verify exported key data 
**************************************************************************************/                                
DxError_t SEP_KMNG_ATP_Ext_ImportExportSymKeys( void ) 
{

	/********* TST Variables Definitions ************/
	DxUint32_t					TST_index = 0; 
	DxError_t					TST_TestStatus = DX_SUCCESS;        
	DxUint8_t					TST_KeyRingPwd[TST_KMNG_PWD_MAX_LEN] = {0x0,0x1,0x2,0x3,0x4,0x5,0x6,0x7,0x8,0x9};
	DxUint32_t					TST_KeyRingPwdLen = 10;
	DxChar						TST_MasterTestName[TST_FUNC_STRING_LEN] = "SEP_KMNG_ATP_Ext_ImportExportSymKeys";     

	/* paramaters for create key */
	KMNG_KeyDataParameter_t		TST_masterKeyDataParam;
	
	/* configuration parameters */
	KMNG_KeyConfiguration_t		TST_masterKeyConfiguration;

	/* paramaters for create key */
	KMNG_KeyDataParameter_t		TST_userKeyDataParam;

	/* configuration parameters */
	KMNG_KeyConfiguration_t		TST_userKeyConfiguration;

	/* configuration parameters */
	KMNG_KeyConfiguration_t		TST_exportedUserKeyConfiguration;

	/* key buffer for master key */
	DxUint8_t					TST_encryptedKeyBuffer[KMNG_SYM_ENCR_KEY_BUFF_SIZE_IN_BYTES];
	/* key buffer for user key */
	DxUint8_t					TST_userEncryptedKeyBuffer[KMNG_SYM_ENCR_KEY_BUFF_SIZE_IN_BYTES];

	/* buffer to save encrypted key */
	DxUint8_t					TST_savedEncryptedKeyBuffer[KMNG_SYM_ENCR_KEY_BUFF_SIZE_IN_BYTES];
	DxUint32_t					TST_savedEncryptedKeyDataLength;
	
	/* set master key parameters (should be AES key) */
	TST_masterKeyDataParam.keyPassword_ptr = TST_KeyRingPwd;
	TST_masterKeyDataParam.keyPasswordLen  = TST_KeyRingPwdLen;
	TST_masterKeyDataParam.encryptedKeyData_ptr   = (DxUint8_t*)TST_encryptedKeyBuffer;
	TST_masterKeyDataParam.encryptedKeyDataLength = KMNG_SYM_ENCR_KEY_BUFF_SIZE_IN_BYTES;

	/* set master key configuration */
	TST_masterKeyConfiguration.type = KMNG_KeyTypeAES; 
	TST_masterKeyConfiguration.keySizeBytes = KMNG_AES_MAX_KEY_SIZE_IN_BYTES; /*256 Bits Key*/
	TST_masterKeyConfiguration.usage = KMNG_KEY_USAGE_STORAGE;
	TST_masterKeyConfiguration.restriction = KMNG_KEY_RESTRICTION_NON_EXPORTABLE;  /* instead PROTECTED.  May be other?? */

	/* 1. Create a master key */
	/**************************/
	TST_TestStatus = LLF_KMNG_CreateKeyRingKey(&TST_masterKeyDataParam , &TST_masterKeyConfiguration);

	TST_ATP_CHECK_ERROR_RETURN( TST_TestStatus,
								"LLF_KMNG_CreateKeyRingKey",
								SEP_KeysOpSym_TestData[TST_index].TST_Name,
								TST_MasterTestName);

	/* save master key, because it will be unwrapped in each KMNG operation */
	DX_VOS_FastMemCpy(TST_savedEncryptedKeyBuffer, TST_masterKeyDataParam.encryptedKeyData_ptr, KMNG_SYM_ENCR_KEY_BUFF_SIZE_IN_BYTES);
	TST_savedEncryptedKeyDataLength = TST_masterKeyDataParam.encryptedKeyDataLength;

	/* set user key parameters */
	TST_userKeyDataParam.keyPassword_ptr = SEP_KeysOpSym_TestData[TST_index].TST_KeyPwd;
	TST_userKeyDataParam.keyPasswordLen = SEP_KeysOpSym_TestData[TST_index].TST_KeyPwdLen;
	/* TST_userKeyDataParam.keyId - will return from LLF layer */
	TST_userKeyDataParam.encryptedKeyData_ptr = (DxUint8_t*)TST_userEncryptedKeyBuffer;
	TST_userKeyDataParam.encryptedKeyDataLength = KMNG_SYM_ENCR_KEY_BUFF_SIZE_IN_BYTES;

	/* set key configuration */
	TST_userKeyConfiguration.type = SEP_KeysOpSym_TestData[TST_index].TST_KeyType;
	TST_userKeyConfiguration.usage = SEP_KeysOpSym_TestData[TST_index].TST_KeyUsage;
	TST_userKeyConfiguration.keySizeBytes = SEP_KeysOpSym_TestData[TST_index].TST_KeySize;  
	TST_userKeyConfiguration.restriction = SEP_KeysOpSym_TestData[TST_index].TST_KeyRestriction;

	/* if UserSpecificKeyData is not NULL, then copy user specific data into configuration structure,
	else set it to 0  */
	TST_userKeyConfiguration.UserSpecificKeyData[0] = SEP_KeysOpSym_TestData[TST_index].TST_UserData[0];
	TST_userKeyConfiguration.UserSpecificKeyData[1] = SEP_KeysOpSym_TestData[TST_index].TST_UserData[1];  	



	/* 2. Import symmetric key */
	/*********************/
	TST_TestStatus = LLF_KMNG_ImportSymUserKey(&TST_masterKeyDataParam,
		&TST_userKeyConfiguration ,
		&TST_userKeyDataParam ,
		SEP_KeysOpSym_TestData[TST_index].TST_key);


	TST_ATP_CHECK_ERROR_RETURN(TST_TestStatus,
		"LLF_KMNG_ImportSymUserKey",
		SEP_KeysOpSym_TestData[TST_index].TST_Name,
		TST_MasterTestName);
	
	/* restore the encrypted key: */
	DX_VOS_FastMemCpy(TST_masterKeyDataParam.encryptedKeyData_ptr, TST_savedEncryptedKeyBuffer, KMNG_SYM_ENCR_KEY_BUFF_SIZE_IN_BYTES);
	TST_masterKeyDataParam.encryptedKeyDataLength = TST_savedEncryptedKeyDataLength;

	/* 3. Export symmetric key */
	TST_TestStatus = LLF_KMNG_ExportSymUserKey(
										  &TST_masterKeyDataParam, 
										  &TST_exportedUserKeyConfiguration, 
										  &TST_userKeyDataParam, 
										  SEP_KeysOpSym_TestData[TST_index].TST_Exportedkey,
										  &SEP_KeysOpSym_TestData[TST_index].TST_KeySize);

	TST_ATP_CHECK_ERROR_RETURN(	TST_TestStatus,
								"LLF_KMNG_ExportSymUserKey",
								SEP_KeysOpSym_TestData[TST_index].TST_Name,
								TST_MasterTestName);

	/* 4. Verify exported data */
	/***************************/
	/* Verify key type */
	if (SEP_KeysOpSym_TestData[TST_index].TST_KeyType != TST_exportedUserKeyConfiguration.type)
	{
		ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"Exported key is different than expected \n"));
		return (DxError_t)KMNG_TEST_FAIL;  
	}

	/* Verify key size */
	if (SEP_KeysOpSym_TestData[TST_index].TST_KeySize != TST_exportedUserKeyConfiguration.keySizeBytes)
	{
		ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"Exported key is different than expected \n"));
		return (DxError_t)KMNG_TEST_FAIL;  
	}

	/* Verify key usage */
	if (SEP_KeysOpSym_TestData[TST_index].TST_KeyUsage != TST_exportedUserKeyConfiguration.usage)
	{
		ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"Exported key is different than expected \n"));
		return (DxError_t)KMNG_TEST_FAIL;  
	}

	/* Verify key restriction */
	if (SEP_KeysOpSym_TestData[TST_index].TST_KeyRestriction != TST_exportedUserKeyConfiguration.restriction)
	{
		ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"Exported key is different than expected \n"));
		return (DxError_t)KMNG_TEST_FAIL;  
	}

	/* Verify key data*/
	TST_TestStatus = (DxUint32_t)DX_VOS_MemCmp((DxUint8_t*)SEP_KeysOpSym_TestData[TST_index].TST_Exportedkey,(DxUint8_t*)SEP_KeysOpSym_TestData[TST_index].TST_key, 
		SEP_KeysOpSym_TestData[TST_index].TST_KeySize*sizeof(DxUint8_t));

	/* comparison should fail in case of created key */
	if (TST_TestStatus != DX_SUCCESS)
	{
		ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"Exported key is different than expected \n"));
		return (DxError_t)KMNG_TEST_FAIL;    
	}

EXIT_ON_ERROR:
	return TST_TestStatus; 
}

/***********************************************************************
* Function Name:                                                           
*  SEP_KMNG_ATP_Ext_ImportExportRSAKeys         
* 
* Inputs:
*
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for create, import, export of the symmetric keys.
* Algorithm:       
* 1. Create a master key
* 2. Import RSA key
* 3. Export RSA key                                            
* 4. Verify exported RSA key data 
**************************************************************************************/                                
DxError_t SEP_KMNG_ATP_Ext_ImportExportRSAKeys( void ) 
{

	/********* TST Variables Definitions ************/
	DxUint32_t					TST_index = 0; 
	DxError_t					TST_Status = DX_SUCCESS;        
	// master key password:
	DxUint8_t					TST_KeyRingPwd[TST_KMNG_PWD_MAX_LEN] = {0x0,0x1,0x2,0x3,0x4,0x5,0x6,0x7,0x8,0x9};
	DxUint32_t					TST_KeyRingPwdLen = 10;
	DxChar						TST_MasterTestName[TST_FUNC_STRING_LEN] = "SEP_KMNG_ATP_Ext_ImportExportRSAKeys";     

	/* paramaters for create key */
	KMNG_KeyDataParameter_t		TST_masterKeyDataParam;

	/* configuration parameters */
	KMNG_KeyConfiguration_t		TST_masterKeyConfiguration;

	/* paramaters for create key */
	KMNG_KeyDataParameter_t		TST_userKeyDataParam;

	/* configuration parameters */
	KMNG_KeyConfiguration_t		TST_userKeyConfiguration;

	/* configuration parameters */
	KMNG_KeyConfiguration_t		TST_exportedUserKeyConfiguration;

	DxUint8_t					TST_savedEncryptedKeyBuffer[KMNG_SYM_ENCR_KEY_BUFF_SIZE_IN_BYTES];
	DxUint32_t					TST_savedEncryptedKeyDataLength;

	/* for master key */
	DxUint8_t					TST_encryptedKeyBuffer[KMNG_SYM_ENCR_KEY_BUFF_SIZE_IN_BYTES];
	/* data for encrypted key data */
	DxUint8_t                   TST_userEncryptedKeyBuffer[KMNG_RSA_ENCR_KEY_BUFF_SIZE_IN_BYTES];
	

	/* set master key paramaters (should be AES key) */
	TST_masterKeyDataParam.keyPassword_ptr = TST_KeyRingPwd;
	TST_masterKeyDataParam.keyPasswordLen = TST_KeyRingPwdLen;
	TST_masterKeyDataParam.encryptedKeyData_ptr = (DxUint8_t*)TST_encryptedKeyBuffer;
	TST_masterKeyDataParam.encryptedKeyDataLength = KMNG_SYM_ENCR_KEY_BUFF_SIZE_IN_BYTES;

	/* set master key configuration */
	TST_masterKeyConfiguration.type = KMNG_KeyTypeAES; 
	TST_masterKeyConfiguration.keySizeBytes = KMNG_AES_MAX_KEY_SIZE_IN_BYTES; /*256 Bits Key*/
	TST_masterKeyConfiguration.usage = KMNG_KEY_USAGE_STORAGE;
	TST_masterKeyConfiguration.restriction = KMNG_KEY_RESTRICTION_NON_EXPORTABLE;  /* instead PROTECTED.  May be other?? */

	/* 1. Create a master key */
	TST_Status = LLF_KMNG_CreateKeyRingKey(&TST_masterKeyDataParam , &TST_masterKeyConfiguration);

	TST_ATP_CHECK_ERROR_RETURN(
							TST_Status,
							"LLF_KMNG_CreateKeyRingKey",
							SEP_KeysOpRSA_TestData[TST_index].TST_Name,
							TST_MasterTestName);

	/* save master key, because it will be unwrapped in each KMNG operation */
	DX_VOS_FastMemCpy(TST_savedEncryptedKeyBuffer, TST_masterKeyDataParam.encryptedKeyData_ptr, KMNG_SYM_ENCR_KEY_BUFF_SIZE_IN_BYTES);
	TST_savedEncryptedKeyDataLength = TST_masterKeyDataParam.encryptedKeyDataLength;

	/* set user key paramaters */
	TST_userKeyDataParam.keyPassword_ptr = SEP_KeysOpRSA_TestData[TST_index].TST_KeyPwd;
	TST_userKeyDataParam.keyPasswordLen = SEP_KeysOpRSA_TestData[TST_index].TST_KeyPwdLen;
	/* TST_userKeyDataParam.keyId - will return from LLF layer */
	TST_userKeyDataParam.encryptedKeyData_ptr = (DxUint8_t*)TST_userEncryptedKeyBuffer;
	TST_userKeyDataParam.encryptedKeyDataLength = KMNG_RSA_ENCR_KEY_BUFF_SIZE_IN_BYTES;


	/* set key configuration */
	TST_userKeyConfiguration.type = SEP_KeysOpRSA_TestData[TST_index].TST_KeyType;
	TST_userKeyConfiguration.usage = SEP_KeysOpRSA_TestData[TST_index].TST_KeyUsage;
	TST_userKeyConfiguration.keySizeBytes = SEP_KeysOpRSA_TestData[TST_index].TST_KeySize;  
	TST_userKeyConfiguration.restriction = SEP_KeysOpRSA_TestData[TST_index].TST_KeyRestriction;

	/* if UserSpecificKeyData is not NULL, then copy user specific data into configuration structure,
	else set it to 0  */
	TST_userKeyConfiguration.UserSpecificKeyData[0] = SEP_KeysOpRSA_TestData[TST_index].TST_UserData[0];
	TST_userKeyConfiguration.UserSpecificKeyData[1] = SEP_KeysOpRSA_TestData[TST_index].TST_UserData[1];  	

	/* 2. Import RSA key */
	TST_Status = LLF_KMNG_ImportRSAUserKey(&TST_masterKeyDataParam , 
		&TST_userKeyConfiguration , 
		&TST_userKeyDataParam , 
		SEP_KeysOpRSA_TestData[TST_index].TST_N,
		SEP_KeysOpRSA_TestData[TST_index].TST_NSize,
		SEP_KeysOpRSA_TestData[TST_index].TST_E,
		SEP_KeysOpRSA_TestData[TST_index].TST_ESize,
		SEP_KeysOpRSA_TestData[TST_index].TST_D,
		SEP_KeysOpRSA_TestData[TST_index].TST_DSize);

	TST_ATP_CHECK_ERROR_RETURN( TST_Status,
								"LLF_KMNG_ImportRSAUserKey",
								SEP_KeysOpRSA_TestData[TST_index].TST_Name,
								TST_MasterTestName);

	/* restore the encrypted key: */
	DX_VOS_FastMemCpy(TST_masterKeyDataParam.encryptedKeyData_ptr, TST_savedEncryptedKeyBuffer, KMNG_SYM_ENCR_KEY_BUFF_SIZE_IN_BYTES);
	TST_masterKeyDataParam.encryptedKeyDataLength = TST_savedEncryptedKeyDataLength;

	/* 3. Export RSA key */
	/*********************/
	SEP_KeysOpRSA_TestData[TST_index].TST_ExportedNSize = TST_KMNG_RSA_2048_KEYSIZE*TST_KMNG_BITS_IN_BYTE;
	SEP_KeysOpRSA_TestData[TST_index].TST_ExportedDSize = TST_KMNG_RSA_2048_KEYSIZE*TST_KMNG_BITS_IN_BYTE;
	SEP_KeysOpRSA_TestData[TST_index].TST_ExportedESize = TST_KMNG_BITS_IN_BYTE*4;

	TST_Status = LLF_KMNG_ExportRSAUserKey(&TST_masterKeyDataParam , 
		&TST_exportedUserKeyConfiguration, 
		&TST_userKeyDataParam , 
		SEP_KeysOpRSA_TestData[TST_index].TST_ExportedN,
		&SEP_KeysOpRSA_TestData[TST_index].TST_ExportedNSize,
		SEP_KeysOpRSA_TestData[TST_index].TST_ExportedE,
		&SEP_KeysOpRSA_TestData[TST_index].TST_ExportedESize,
		SEP_KeysOpRSA_TestData[TST_index].TST_ExportedD,
		&SEP_KeysOpRSA_TestData[TST_index].TST_ExportedDSize);


	TST_ATP_CHECK_ERROR_RETURN( TST_Status,
								"LLF_KMNG_ExportRSAUserKey",
								SEP_KeysOpRSA_TestData[TST_index].TST_Name,
								TST_MasterTestName);

	/* 4. Verify exported RSA key data */
	/***********************************/
	TST_Status = (DxUint32_t)DX_VOS_MemCmp((DxUint8_t*)SEP_KeysOpRSA_TestData[TST_index].TST_ExportedE,(DxUint8_t*)SEP_KeysOpRSA_TestData[TST_index].TST_E, 
		SEP_KeysOpRSA_TestData[TST_index].TST_ExportedESize*sizeof(DxUint8_t));

	/* comparison should fail in case of created key */
	if (TST_Status != DX_SUCCESS)
	{
		ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"Exported E is different than expected \n"));
		return KMNG_TEST_FAIL;    
	}

	TST_Status = (DxUint32_t)DX_VOS_MemCmp((DxUint8_t*)SEP_KeysOpRSA_TestData[TST_index].TST_ExportedN,(DxUint8_t*)SEP_KeysOpRSA_TestData[TST_index].TST_N, 
		SEP_KeysOpRSA_TestData[TST_index].TST_ExportedNSize *sizeof(DxUint8_t));

	/* comparison should fail in case of created key */
	if (TST_Status != DX_SUCCESS)
	{
		ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"Exported N is different than expected \n"));
		return KMNG_TEST_FAIL;    
	}

	TST_Status = (DxUint32_t)DX_VOS_MemCmp((DxUint8_t*)SEP_KeysOpRSA_TestData[TST_index].TST_ExportedD,SEP_KeysOpRSA_TestData[TST_index].TST_D, 
		SEP_KeysOpRSA_TestData[TST_index].TST_ExportedDSize*sizeof(DxUint8_t));

	/* comparison should fail in case of created key */
	if (TST_Status != DX_SUCCESS)
	{
		ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"Exported D is different than expected \n"));
		return KMNG_TEST_FAIL;    
	}	

EXIT_ON_ERROR:
	return TST_Status; 	
}

